/*
 * Decompiled with CFR 0.152.
 */
package jclass.image;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import jclass.image.ByteString;
import jclass.image.NewLZWHashtable;

public class GifConverter
implements ImageConsumer {
    private ImageProducer source;
    private OutputStream destination;
    private Vector colors = new Vector();
    private int[] imagePixels;
    private int imageWidth;
    private int imageHeight;
    private byte[] buffer = new byte[256];
    private Thread myThread;
    private byte[] bitBuffer = new byte[255];
    private int currentBit;

    public GifConverter(ImageProducer imageProducer, OutputStream outputStream) {
        this.source = imageProducer;
        this.setDestination(outputStream);
    }

    public GifConverter(Image image, OutputStream outputStream) {
        this(image.getSource(), outputStream);
    }

    public void setSource(Image image) {
        this.source = image.getSource();
    }

    public void setDestination(OutputStream outputStream) {
        this.destination = outputStream;
    }

    public Thread getThread() {
        return this.myThread;
    }

    public synchronized void convert() throws IOException {
        this.source.startProduction(this);
    }

    public synchronized void convertSynchronous() throws IOException {
        this.convert();
        try {
            do {
                Thread.sleep(10L);
            } while (this.myThread == null);
            this.myThread.join();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void putByte(byte by) throws IOException {
        this.destination.write(by);
    }

    private void putWord(short s) throws IOException {
        this.putByte((byte)(s & 0xFF));
        this.putByte((byte)(s >> 8 & 0xFF));
    }

    private void putString(String string) throws IOException {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            this.putByte((byte)cArray[n]);
            ++n;
        }
    }

    private void putBits(int n, int n2) throws IOException {
        int n3 = this.currentBit / 8;
        int n4 = this.currentBit % 8;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = n3++;
            this.bitBuffer[n6] = (byte)(this.bitBuffer[n6] | (n & 1) << n4);
            n >>= 1;
            ++n4;
            ++this.currentBit;
            if (this.currentBit == 2040) {
                --this.currentBit;
                this.flushBits();
                n3 = this.currentBit / 8;
                n4 = this.currentBit % 8;
            } else if (n4 == 8) {
                n4 = 0;
            }
            ++n5;
        }
    }

    private void flushBits() throws IOException {
        int n = this.currentBit / 8 + 1;
        this.putByte((byte)n);
        int n2 = 0;
        while (n2 < n) {
            this.putByte(this.bitBuffer[n2]);
            this.bitBuffer[n2] = 0;
            ++n2;
        }
        this.currentBit = 0;
    }

    private void produceGIF() throws IOException {
        int n = 0;
        if (this.colors.size() >= 256) {
            throw new IndexOutOfBoundsException("Too many colors in GIF!");
        }
        n = this.colors.size() <= 2 ? 1 : (this.colors.size() <= 4 ? 2 : (this.colors.size() <= 16 ? 4 : (this.colors.size() <= 32 ? 5 : (this.colors.size() <= 64 ? 6 : 8))));
        int n2 = 1 << n;
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            if (n3 < this.colors.size()) {
                Color color = (Color)this.colors.elementAt(n3);
                byArray[n3] = (byte)color.getRed();
                byArray2[n3] = (byte)color.getGreen();
                byArray3[n3] = (byte)color.getBlue();
            } else {
                byArray[n3] = 0;
                byArray2[n3] = 0;
                byArray3[n3] = 0;
            }
            ++n3;
        }
        this.putString("GIF87a");
        this.putWord((short)this.imageWidth);
        this.putWord((short)this.imageHeight);
        byte by = 0;
        by = (byte)(by | n - 1);
        by = (byte)(by | 0x70);
        by = (byte)(by | 0x80);
        this.putByte(by);
        this.putByte((byte)0);
        this.putByte((byte)0);
        int n4 = 0;
        while (n4 < n2) {
            this.putByte(byArray[n4]);
            this.putByte(byArray2[n4]);
            this.putByte(byArray3[n4]);
            ++n4;
        }
        this.putByte((byte)44);
        this.putWord((short)0);
        this.putWord((short)0);
        this.putWord((short)this.imageWidth);
        this.putWord((short)this.imageHeight);
        this.putByte((byte)0);
        this.putByte((byte)n);
        this.compressData(n);
        this.putByte((byte)0);
        this.putByte((byte)59);
        int n5 = 0;
        while (n5 < 9) {
            this.putByte((byte)0);
            ++n5;
        }
        this.destination.flush();
        System.out.println("Done produceGIF");
    }

    private void compressData(int n) throws IOException {
        int n2;
        System.out.println("starting compressData with " + this.imagePixels.length + " pixels");
        NewLZWHashtable newLZWHashtable = new NewLZWHashtable(12, n);
        int n3 = 0;
        this.putBits(newLZWHashtable.clearCode, newLZWHashtable.currentCodeSize);
        ByteString byteString = new ByteString();
        while (true) {
            if (n3 == this.imagePixels.length) break;
            byte by = (byte)this.imagePixels[n3++];
            ByteString byteString2 = new ByteString(byteString);
            byteString2.append(by);
            n2 = newLZWHashtable.getCodeForString(byteString2);
            if (newLZWHashtable.isFull()) {
                byteString.clear();
                this.putBits(n2, newLZWHashtable.currentCodeSize);
                this.putBits(newLZWHashtable.clearCode, newLZWHashtable.currentCodeSize);
                newLZWHashtable.clear();
                continue;
            }
            if (n2 == -1) {
                newLZWHashtable.addString(byteString2);
                n2 = newLZWHashtable.getCodeForString(byteString);
                this.putBits(n2, newLZWHashtable.currentCodeSize);
                byteString = new ByteString(by);
                continue;
            }
            byteString = byteString2;
        }
        n2 = newLZWHashtable.getCodeForString(byteString);
        this.putBits(n2, newLZWHashtable.currentCodeSize);
        this.putBits(newLZWHashtable.endOfInformationCode, newLZWHashtable.currentCodeSize);
        this.flushBits();
        System.out.println("done compressData");
    }

    public void imageComplete(int n) {
        this.myThread = Thread.currentThread();
        if (n == 3) {
            try {
                this.produceGIF();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public void setColorModel(ColorModel colorModel) {
        this.myThread = Thread.currentThread();
    }

    public void setDimensions(int n, int n2) {
        this.myThread = Thread.currentThread();
        this.imageWidth = n;
        this.imageHeight = n2;
        this.imagePixels = new int[n * n2];
    }

    public void setHints(int n) {
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        try {
            int n7 = 0;
            while (n7 < n4) {
                int n8 = 0;
                while (n8 < n3) {
                    int n9 = n + n8;
                    int n10 = n2 + n7;
                    byte by = byArray[n7 * n6 + n8 + n5];
                    Color color = new Color(colorModel.getRed(by), colorModel.getGreen(by), colorModel.getBlue(by));
                    int n11 = this.colors.indexOf(color);
                    if (n11 == -1) {
                        n11 = this.colors.size();
                        this.colors.addElement(color);
                    }
                    this.imagePixels[n10 * this.imageWidth + n9] = n11;
                    ++n8;
                }
                ++n7;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                int n9 = n + n8;
                int n10 = n2 + n7;
                int n11 = nArray[n7 * n6 + n8 + n5];
                Color color = new Color(colorModel.getRed(n11), colorModel.getGreen(n11), colorModel.getBlue(n11));
                int n12 = this.colors.indexOf(color);
                if (n12 == -1) {
                    n12 = this.colors.size();
                    this.colors.addElement(color);
                }
                this.imagePixels[n10 * this.imageWidth + n9] = n12;
                ++n8;
            }
            ++n7;
        }
    }

    public void setProperties(Hashtable hashtable) {
    }
}

